<?php
/**
 * *************************************************************************
 * PROJECT: Tahalya app
 * Powered by IT PLUS Team
 * Copyright 2020 IT Plus Inc
 * http://it-plus.co/
 * *************************************************************************
 */

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

require_once 'init.php';

if (empty($_SERVER['HTTPS']) || $_SERVER['HTTPS'] === 'off') {
    die(json_encode(["error" => "Secure connection required."]));
}

$headers = getallheaders();
$whatsapp_token = $headers['Authorization-Token'] ?? null;

$inputJSON = file_get_contents("php://input");
$input = json_decode($inputJSON, true);

$phone_number_id = filter_var($input['phone_number_id'] ?? null, FILTER_SANITIZE_STRING);
$template_name = filter_var($input['template_name'] ?? null, FILTER_SANITIZE_STRING);
$recipient_numbers = filter_var($input['recipient_numbers'] ?? null, FILTER_SANITIZE_STRING);

if (!$whatsapp_token || !$phone_number_id || !$template_name || !$recipient_numbers) {
    die(json_encode(["error" => "Missing required parameters!"]));
}


function isValidPhone($phone) {
    return preg_match('/^\+?[1-9]\d{7,14}$/', $phone);
}

$recipients = array_filter(explode(",", str_replace(" ", "", $recipient_numbers)), 'isValidPhone');

function sendWhatsAppMessage($whatsapp_token, $phone_number_id, $recipient_phone, $template_name)
{
    $url = "https://graph.facebook.com/v22.0/$phone_number_id/messages";

    $data = [
        "messaging_product" => "whatsapp",
        "to" => $recipient_phone,
        "type" => "template",
        "template" => [
            "name" => $template_name,
            "language" => ["code" => "en_US"]
        ]
    ];

    $headers = [
        "Authorization: Bearer $whatsapp_token",
        "Content-Type: application/json"
    ];

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 2);

    $response = curl_exec($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    return ["phone" => $recipient_phone, "http_code" => $http_code, "response" => json_decode($response, true)];
}

$results = [];
foreach ($recipients as $phone) {
    $results[] = sendWhatsAppMessage($whatsapp_token, $phone_number_id, trim($phone), $template_name);
}

echo json_encode($results, JSON_PRETTY_PRINT);
?>
