<?php

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

require_once 'init.php';

$inputJSON = file_get_contents("php://input");
$input = json_decode($inputJSON, true);

$action = $_GET['action'] ?? null;
$phone = $input['recipient_numbers'] ?? null;
$otp = $input['otp'] ?? null;
$new_password = $input['new_password'] ?? null;

$whatsapp_token = $headers['Authorization-Token'] ?? null;
$phone_number_id = $input['phone_number_id'] ?? null;
// print_r($phone_number_id);die;


switch ($action) {
    case 'send_otp':
        if (!$phone || !$whatsapp_token || !$phone_number_id) {
            echo json_encode(["error" => "Missing required parameters!"]);
            exit;
        }
        $generated_otp = rand(100000, 999999);
        $ForgetPasswordObj->saveOtp($phone, $generated_otp);
        $response = $ForgetPasswordObj->sendWhatsAppOTP($whatsapp_token, $phone_number_id, $phone, $generated_otp);
        echo json_encode($response);
        break;

    case 'verify_otp':
        if (!$phone || !$otp) {
            echo json_encode(["error" => "Missing required parameters!"]);
            exit;
        }
        $is_valid = $ForgetPasswordObj->verifyOtp($phone, $otp);
        echo json_encode(["valid" => $is_valid]);
        break;

    case 'reset_password':
        if (!$phone || !$new_password) {
            echo json_encode(["error" => "Missing required parameters!"]);
            exit;
        }
        $result = $ForgetPasswordObj->resetPassword($phone, $new_password);
        echo json_encode($result);
        break;

    default:
        echo json_encode(["error" => "Invalid action!"]);
        break;
}
