<?php

$ForgetPasswordObj = new ForgetPassword();

class ForgetPassword
{

	var $mDb;
	var $mConfig;
	var $mlang;
    

	function __construct()
	{
		global $Config;
		global $Lang;
		$this->mDb = new iplus();
		$this->mConfig = $Config;
		$this->mlang = $Lang;
     
	}
    public function saveOtp($phone, $otp)
    {
        // print_r($otp);die;
        $sql = "INSERT INTO otp_verification (phone, otp, created_at) VALUES (?, ?, NOW()) 
                ON DUPLICATE KEY UPDATE otp = VALUES(otp), created_at = NOW()";
        $stmt = $this->mDb->connect()->prepare($sql);
        $stmt->execute([$phone, $otp]);
    }

    public function verifyOtp($phone, $otp)
    {
        $sql = "SELECT * FROM otp_verification WHERE phone = ? AND otp = ? AND created_at >= NOW() - INTERVAL 5 MINUTE";
        $stmt = $this->mDb->connect()->prepare($sql);
        $stmt->execute([$phone, $otp]);
        return $stmt->rowCount() > 0;
    }

    public function sendWhatsAppOTP($whatsapp_token, $phone_number_id, $recipient_phone, $otp)
    {
        $url = "https://graph.facebook.com/v22.0/$phone_number_id/messages";
        $data = [
            "messaging_product" => "whatsapp",
            "to" => $recipient_phone,
            "type" => "template",
            "template" => [
                "name" => "otp_template",
                "language" => ["code" => "en_US"],
                "components" => [
                    [
                        "type" => "body",
                        "parameters" => [["type" => "text", "text" => $otp]]
                    ]
                ]
            ]
        ];

        $headers = [
            "Authorization: Bearer $whatsapp_token",
            "Content-Type: application/json"
        ];

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));

        $response = curl_exec($ch);
        curl_close($ch);

        return json_decode($response, true);
    }

    public function resetPassword($phone, $new_password)
    {
        $hashed_password = password_hash($new_password, PASSWORD_BCRYPT);
        $sql = "UPDATE users SET password = ? WHERE phone = ?";
        $stmt = $this->mDb->connect()->prepare($sql);
        $stmt->execute([$hashed_password, $phone]);

        return ["status" => "success", "message" => "Password reset successful!"];
    }
}
?>

